﻿namespace Hims.Api.Filters
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// Policy Selector With Label
    /// </summary>
    /// <typeparam name="T">The entity</typeparam>
    public class PolicySelectorWithLabel<T> where T : Attribute
    {
        /// <summary>
        /// Gets or sets the selector.
        /// </summary>
        public Func<IEnumerable<T>, IEnumerable<string>> Selector { get; set; }

        /// <summary>
        ///  Gets or sets the label.
        /// </summary>
        public string Label { get; set; }
    }
}
